#----------------------------------------------------------
# TEMP-SENSOR TESTER PYTHON
#----------------------------------------------------------
# needs "hidapi" library: pip install hidapi
# conflict with "hid" library: pip uninstall hid
#----------------------------------------------------------
"""
Data struct:

d[0] = Sensor number read
d[1] = Sensor count
d[2] = Power (Extern, Parasite)
d[4,5] = Temperature
d[8..15] = Serial number
"""
#----------------------------------------------------------
import sys
import hid

try:
  h = hid.device()
  h.open(0x16C0, 0x0480)    # TEMP-TESTER
except:
  print("No Temp-Tester found")
  sys.exit(1)

print("Manufacturer: %s" % h.get_manufacturer_string())
print("Product: %s" % h.get_product_string())
print("Serial No: %s" % h.get_serial_number_string())
print("==================================================")

while True:
  d = h.read(64)
  if d:
    if d[2] == 0:
      s = "P"
    else:
      s = "E"  
    deg = d[4] + (256 * d[5])
    neg = ""
    if deg > 32767:
      deg = 65536 - deg
      neg = "-"
    print("%d/%d [%s] (%02X:%02X:%02X:%02X:%02X:%02X:%02X:%02X) %s%.1f°C" % 
       (d[1], d[0], s, d[8], d[9], d[10], d[11], d[12], d[13], d[14], d[15], neg, deg / 10))
    if d[1] == d[0]:
      print("--------------------------------------------------")
  else:
    break

#----------------------------------------------------------
